<?php 

global $whmcs_bridge_enabled;

require 'vendor/autoload.php';

use Helge\Loader\JsonLoader;
use Helge\Client\SimpleWhoisClient;
use Helge\Service\DomainAvailability;


if( function_exists('cc_whmcs_bridge_home')){
    $whmcs_bridge_enabled = true;
}

/**
 *
 * WHMCS Bridge Page URL
 *
 */
if(!function_exists('void_ewhmcsep_whmcs_bridge_url')){
function void_ewhmcsep_whmcs_bridge_url() {
  return cc_whmcs_bridge_home($home,$pid);
}
}


//Metod 1
// function void_ewhmcsep_ajax_domain_function(){  
//     $json = file_get_contents('http://api.bulkwhoisapi.com/whoisAPI.php?domain='.$_POST["domain"].'&type=whois&token=7d3f08b98ab9f69ae15060a5b58ef1ee');
//     //$json = json_decode($json,true);
//     $json = json_decode($json);
//     $json = json_encode( $json->response_code );
//     echo $json;
//     wp_die(); 
// }

//Metod 2
function void_ewhmcsep_ajax_domain_function(){  


    $whmcs_url= trailingslashit(get_option('void_whmcse_url'));
    $whmcs_identifier=get_option('void_whmcse_identifier_key'); 
    $whmcs_secret=get_option('void_whmcse_secret_key'); 
    $is_admin_user=  current_user_can( 'administrator' );

    if($_POST['searchmethod']==='whmcs' ){
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $whmcs_url.'/includes/api.php');
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS,
            http_build_query(
                array(
                    'action' => 'DomainWhois',
                    'username' => $whmcs_identifier,
                    'password' => $whmcs_secret,
                    'domain' => $_POST['domain'],
                    'responsetype' => 'json',
                )
            )
        );
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $json = curl_exec($ch);
        curl_close($ch);

        $data = json_decode($json, true);

    }else if($_POST['searchmethod']==='internal'){

        $whoisClient = new SimpleWhoisClient();
        $dataLoader = new JsonLoader(plugin_dir_path(__FILE__)."/vendor/helgesverre/domain-availability/src/data/servers.json");

        $service = new DomainAvailability($whoisClient, $dataLoader);

        if($service->isAvailable($_POST['domain'])){
            $data['status']='available';
        }else{
            $data['status']='unavailable';
        }

    }else{

        $data['status']='This metod is not yet supported. This might be implemented in future';

    }
    
    // $json = file_get_contents('http://whoiz.herokuapp.com/lookup.json?url='.$_POST['domain']);    
    $data['is_admin']=$is_admin_user;

    $json = json_encode($data);

    echo $json; 
    wp_die(); 
}
add_action( 'wp_ajax_void_ewhmcsep_ajax_domain_function', 'void_ewhmcsep_ajax_domain_function' );
add_action( 'wp_ajax_nopriv_void_ewhmcsep_ajax_domain_function', 'void_ewhmcsep_ajax_domain_function' );


